% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplot_data.R
\name{barplot_data}
\alias{barplot_data}
\title{Generate barplots}
\usage{
barplot_data(MACSQuant,plt.col=NULL,plt.conditions=NULL, plt.flavour=NULL,
plt.labels = NULL, plt.combo=FALSE,plt.3D.only = NULL,...)
}
\arguments{
\item{MACSQuant}{object of class MACSQuant resulting of the function
load_maxQuant().
Contains the original data table}

\item{plt.col}{In case of manual run is used to define the bar colors.
(must be the same for all conditions)}

\item{plt.conditions}{user defined vector of conditions to plot
(example: plt.conditions=c(1:9))}

\item{plt.flavour}{Which barplot to produce, cell count or percentage of
fluorochrome
(i.e: "counts","percent")}

\item{plt.labels}{xlabels of the plot}

\item{plt.combo}{Does the experiment involves multiple variables
(i.e some condition are a drug combination screening)}

\item{plt.3D.only}{Whether to plot 3D barplot alone}

\item{...}{params for lattice cloud namely z and x for parameter screen
default for z and x are c(-110,-70) and argument xlab and ylab}
}
\value{
returns a barplot of the data
}
\description{
Uses the informations stored in the statistic tables of
the MACSQuant object to generate barplots for the specified
conditions. Plots can also be saved in the form of a png
file in the output_MQ directory.
}
\examples{
drugs_R_image <- system.file("extdata",
    "drugs.RDS",
    package = "MACSQuantifyR")
MACSQuant <- readRDS(drugs_R_image)
flavour <- "counts"
number_of_conditions <-
    slot(MACSQuant, "param.experiment")$number_of_conditions
plt.col <- c(rep(2, number_of_conditions), 1)
barplot_data(MACSQuant,
    plt.col = plt.col,
    plt.conditions = NULL,
    plt.flavour = flavour,
    plt.labels = NULL,
    plt.combo = FALSE)
}
