% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqMatrix.R
\name{seqMatrix}
\alias{seqMatrix}
\title{Sequence matrix}
\usage{
seqMatrix(productive.aa, sequences)
}
\arguments{
\item{productive.aa}{A list data frames of of productive amino acid sequences 
generated by LymphoSeq function productiveSeq where the aggregate parameter 
was set to "aminoAcid".}

\item{sequences}{A character vector of amino acid sequences of interest.  It 
is useful to specify the output from the LymphoSeq functions uniqueSeqs or 
topSeqs and subsetting the "aminoAcid" column.  See examples below.}
}
\value{
Returns a data frame of unique, productive amino acid sequences as 
rows and the \% frequency it appears in each sample as columns.
}
\description{
Creates a data frame with unique, productive amino acid sequences as rows and 
sample names as headers.  Each value in the data frame represents the 
frequency that the sequence appeared in the sample.
}
\examples{
file.path <- system.file("extdata", "TCRB_sequencing", package = "LymphoSeq")

file.list <- readImmunoSeq(path = file.path)

productive.aa <- productiveSeq(file.list = file.list, aggregate = "aminoAcid")

top.seqs <- topSeqs(productive.seqs = productive.aa, top = 0.1)

sequence.matrix <- seqMatrix(productive.aa = productive.aa, 
   sequences = top.seqs$aminoAcid)

unique.seqs <- uniqueSeqs(productive.aa = productive.aa)

sequence.matrix <- seqMatrix(productive.aa = productive.aa, 
   sequences = unique.seqs$aminoAcid)

# It can be helpful to combine top.freq and sequence.matrix
top.freq <- topFreq(productive.aa = productive.aa, percent = 0)

sequence.matrix <- seqMatrix(productive.aa = productive.aa, sequences = top.freq$aminoAcid)

top.freq.matrix <- merge(top.freq, sequence.matrix)
}
\seealso{
\code{\link{topSeqs}} and \code{\link{uniqueSeqs}}
}
