% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chordDiagramVDJ.R
\name{chordDiagramVDJ}
\alias{chordDiagramVDJ}
\title{Chord diagram of VJ or DJ gene associations}
\usage{
chordDiagramVDJ(sample, association = "VJ", colors = c("red", "blue"))
}
\arguments{
\item{sample}{A data frame consisting of frequencies of antigen receptor 
sequences.  "vFamilyName", "jFamilyName", and if applicable, "dFamilyName" 
are a required columns.  Using output from the LymphoSeq function topSeqs is
recommended.}

\item{association}{A character vector of gene familes to associate.  Options 
include "VJ" or "DJ".}

\item{colors}{A character vector of 2 colors corresponding to the V/D and J 
gene colors respectively.}
}
\value{
Returns a chord diagram showing VJ or DJ gene associations from one or 
more samples.
}
\description{
Creates a chord diagram showing VJ or DJ gene associations from one or more 
samples.
}
\details{
The size of the ribbons connecting VJ or DJ genes correspond to the 
number of samples or number of sequences that make up that recombination 
event.  The thicker the ribbon, the higher the frequency of the recombination.
}
\examples{
file.path <- system.file("extdata", "TCRB_sequencing", package = "LymphoSeq")

file.list <- readImmunoSeq(path = file.path)

productive.nt <- productiveSeq(file.list = file.list, aggregate = "nucleotide")

top.seqs <- topSeqs(productive.seqs = productive.nt, top = 1)

chordDiagramVDJ(sample = top.seqs, association = "VJ", colors = c("red", "blue"))

# Remove "TCRB" from gene family name
top.seqs <- as.data.frame(apply(top.seqs, 2, function(x) gsub("TCRB", "", x)))

chordDiagramVDJ(sample = top.seqs, association = "VJ", colors = c("red", "blue"))
}
\seealso{
\code{\link{topSeqs}}
}
