% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R
\name{odd_chain_result}
\alias{odd_chain_result}
\alias{odd_chain_result,LipidTrendSE-method}
\title{Get Odd Chain Result from LipidTrendSE}
\usage{
odd_chain_result(object)

\S4method{odd_chain_result}{LipidTrendSE}(object)
}
\arguments{
\item{object}{A LipidTrendSE object}
}
\value{
A data frame containing odd chain result. The result table includes
the following columns:
\enumerate{
\item{Feature columns: Lipid feature values from the input \code{rowData},
such as chain length or double bond count. Column names vary depending on
input.}
\item{avg.abund: Mean abundance of each lipid across all samples. For
one-dimensional analysis, this may also include \code{avg.abund.ctrl} and
\code{avg.abund.case} for group-wise means.}
\item{direction: Sign of the smoothed statistic:
\itemize{
\item{+ : Trend increases in the case group.}
\item{- : Trend decreases in the case group.}
}
}
\item{smoothing.pval.BH: Benjamini–Hochberg adjusted p-value from the
region-based permutation test.}
\item{marginal.pval.BH: Benjamini–Hochberg adjusted p-value from the
marginal test (per lipid).}
\item{log2.FC: Log2 fold-change in abundance between case and control
groups.}
\item{significance: Overall significance label based on smoothed test and
FC direction:
\itemize{
\item{Increase: Significant positive trend in case group.}
\item{Decrease: Significant negative trend in case group.}
\item{NS: Not significant.}
}
}
}
}
\description{
Get Odd Chain Result from LipidTrendSE
}
\examples{
data("lipid_se_CL")
res_se <- analyzeLipidRegion(
    lipid_se=lipid_se_CL, ref_group="sgCtrl", split_chain=TRUE,
    chain_col="chain", radius=3, own_contri=0.5, permute_time=100)
# Get complete result summary
results <- odd_chain_result(res_se)
}
