% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarSelection-Class.R
\docType{methods}
\name{sign_values}
\alias{sign_values}
\alias{sign_values,VarSelection-method}
\title{sign_values}
\usage{
\S4method{sign_values}{VarSelection}(x)
}
\arguments{
\item{x}{an object from VarSelection class.}
}
\value{
sign_values, data.frame with the R2 or FDR p-value
for each of the selected variables
}
\description{
Accessor to R2 or p values of the selected variables from VarSelection output.
}
\examples{
{
data(Taraoceans)
pro.phylo <- Taraoceans$taxonomy[ ,'Phylum']
TaraOc<-list(Taraoceans$phychem,as.data.frame(Taraoceans$pro.phylo),
as.data.frame(Taraoceans$pro.NOGs))
TaraOc_1<-scale(TaraOc[[1]])
Normalization<-lapply(list(TaraOc[[2]],TaraOc[[3]]),
function(x){DataProcessing(x,Method='Compositional')})
colnames(Normalization[[1]])=pro.phylo
colnames(Normalization[[2]])=Taraoceans$GO
TaraOc<-list(TaraOc_1,Normalization[[1]],Normalization[[2]])
names(TaraOc)<-c('phychem','pro_phylo','pro_NOGs')
TaraOc<-lapply(TaraOc,as.data.frame)
Output<-LinkData(TaraOc,Scale =FALSE,
Distance = c('ScalarProduct','Euclidean','Euclidean'))
Selection<-VarSelection(Output,TaraOc,Crit='Rsquare',perc=0.95)
sign_values(Selection)
}
}
