% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistStatis-Class.R
\docType{methods}
\name{RQO}
\alias{RQO}
\alias{RQO,DistStatis-method}
\title{RQO}
\usage{
\S4method{RQO}{DistStatis}(x)
}
\arguments{
\item{x}{an object from DistSatis class.}
}
\value{
RQO Representation Quality of the observations in the compromise configuration from LinkData object
}
\description{
Accessor to RQO (% of individuals representation) from LinkData output.
}
\examples{
{
data(Taraoceans)
pro.phylo <- Taraoceans$taxonomy[ ,'Phylum']
TaraOc<-list(Taraoceans$phychem,as.data.frame(Taraoceans$pro.phylo)
,as.data.frame(Taraoceans$pro.NOGs))
TaraOc_1<-scale(TaraOc[[1]])
Normalization<-lapply(list(TaraOc[[2]],TaraOc[[3]]),
function(x){DataProcessing(x,Method='Compositional')})
colnames(Normalization[[1]])=pro.phylo
colnames(Normalization[[2]])=Taraoceans$GO
TaraOc<-list(TaraOc_1,Normalization[[1]],Normalization[[2]])
names(TaraOc)<-c('phychem','pro_phylo','pro_NOGs')
TaraOc<-lapply(TaraOc,as.data.frame)
Output<-LinkData(TaraOc,Scale =FALSE,Distance = c('ScalarProduct','Euclidean','Euclidean'))
RQO(Output)
}
}
