% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GlobalPlot.R
\docType{methods}
\name{GlobalPlot}
\alias{GlobalPlot}
\alias{GlobalPlot,DistStatis-method}
\title{Global-Plot}
\usage{
\S4method{GlobalPlot}{DistStatis}(x)
}
\arguments{
\item{x}{DistStatis class object.}
}
\value{
plotted GlobalPlot/s of the component/s of the given DistStatis object.
}
\description{
this function outputs a plot from a DistStatis object.
The plot shows the projection of  the all common observation
onto each subspace used at the integration step
}
\examples{
{

data(Taraoceans)
pro.phylo <- Taraoceans$taxonomy[ ,'Phylum']
TaraOc<-list(Taraoceans$phychem,as.data.frame(Taraoceans$pro.phylo),
as.data.frame(Taraoceans$pro.NOGs))
TaraOc_1<-scale(TaraOc[[1]])
Normalization<-lapply(list(TaraOc[[2]],TaraOc[[3]]),
function(x){DataProcessing(x,Method='Compositional')})
colnames(Normalization[[1]])=pro.phylo
colnames(Normalization[[2]])=Taraoceans$GO
TaraOc<-list(TaraOc_1,Normalization[[1]],Normalization[[2]])
names(TaraOc)<-c('phychem','pro_phylo','pro_NOGs')
TaraOc<-lapply(TaraOc,as.data.frame)
Output<-LinkData(TaraOc,Scale =FALSE,
Distance = c('ScalarProduct','Euclidean','Euclidean'))
GlobalPlot(Output) +
theme(panel.grid.major = element_blank(),
panel.grid.minor = element_blank(),
panel.background = element_blank(),
axis.line = element_line(colour = 'black'))


}
}
\author{
Laura M. Zingaretti
}
