% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrelationPlot.R
\docType{methods}
\name{CorrelationPlot}
\alias{CorrelationPlot}
\alias{CorrelationPlot,DistStatis-method}
\title{Correlation-Plot}
\usage{
\S4method{CorrelationPlot}{DistStatis}(x,...)
}
\arguments{
\item{x}{an object from DistSatis class.}

\item{...}{additional parameters from ggplot2 library}
}
\value{
correlation plot between tables from a  DistStatis object.
}
\description{
Plot a \code{CorrelationPlot} of a DistStatis object
}
\examples{
{

data(Taraoceans)
pro.phylo <- Taraoceans$taxonomy[ ,'Phylum']
TaraOc<-list(Taraoceans$phychem,as.data.frame(Taraoceans$pro.phylo),
as.data.frame(Taraoceans$pro.NOGs))
TaraOc_1<-scale(TaraOc[[1]])
Normalization<-lapply(list(TaraOc[[2]],TaraOc[[3]]),
function(x){DataProcessing(x,Method='Compositional')})
colnames(Normalization[[1]])=pro.phylo
colnames(Normalization[[2]])=Taraoceans$GO
TaraOc<-list(TaraOc_1,Normalization[[1]],Normalization[[2]])
names(TaraOc)<-c('phychem','pro_phylo','pro_NOGs')
TaraOc<-lapply(TaraOc,as.data.frame)
Output<-LinkData(TaraOc,Scale =FALSE,
Distance = c('ScalarProduct','Euclidean','Euclidean'))
CorrelationPlot(Output) +
theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
panel.background = element_blank(),
axis.line = element_line(colour = 'black'))


}
}
\author{
Laura M. Zingaretti
}
