% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationSelection.R
\name{correlationSelection}
\alias{correlationSelection}
\title{correlationSelection: A vector correlation function calculator}
\usage{
correlationSelection(
  mae,
  type = "Spearman",
  adj = TRUE,
  pValCutoff = 0.05,
  rCutoff = 0,
  sortByCorrs = FALSE
)
}
\arguments{
\item{mae}{a MultiAssayExperiment object containing the methylation}

\item{type}{specifies the correlation to choose between Spearman
and Pearson. Default is Spearman.}

\item{adj}{logical variable indicating if the p-value returned should be
adjusted or not. Default is TRUE, it returns an adjusted p-value.}

\item{pValCutoff}{the upper limit used for the  p-value. Default is 0.05.}

\item{rCutoff}{the upper limit used for the correlation coefficient. 
Default is 0, no cut off.}

\item{sortByCorrs}{logical; if TRUE, results are ordered by ascending 
p-value. Default set to FALSE.}
}
\value{
dataframe with the correlations selected
}
\description{
\code{correlationSelection} Uses the function matCorrs; 
given two matrices X (m,n), Y (m,n) this function computes 
Pearson and Spearman correlation coefficients and their significance p-values
for every pair of row vectors.
}
\examples{

# Methylation data
methylData <- matrix(runif(50), nrow = 10)
colnames(methylData) <- paste0("samp", 1:ncol(methylData))
rownames(methylData) <- paste0("gene", 1:nrow(methylData))
# Expression data
expresData <- matrix(rnorm(50), nrow = 10)
colnames(expresData) <- paste0("samp", 1:ncol(methylData))
rownames(expresData) <- paste0("gene", 1:nrow(methylData))
# ColData
colDat <- data.frame(
    sampleID = colnames(methylData),
    name = letters[1:ncol(methylData)]
)

rownames(colDat) <- colDat$sampleID
mae <- MultiAssayExperiment::MultiAssayExperiment(
    experiments = list(
        methylation = methylData,
        expression = expresData
    ),
    colData = colDat
)
correlationSelection(mae, pValCutoff = 0.25, rCutoff = 0.1, 
type = "Spearman", sortByCorrs = TRUE)
}
\keyword{Calculator}
\keyword{Correlation}
\keyword{Selection}
