% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binScore.R
\name{binScore}
\alias{binScore}
\title{binScore}
\usage{
binScore(aGrid, aReq)
}
\arguments{
\item{aGrid}{A matrix of counts as computed by `calcFreqs` function.}

\item{aReq}{A matrix of minimum or maximum counts to be found in each cell
if L-shape is TRUE.}
}
\value{
a score value for each scatterplot
}
\description{
\code{binScore} can be used to score scatterplots by directly comparing
the sample counts with a matrix of minimal or maximal percentages/counts
to be found in each cell. It implements the three bands rule implicitly
by setting threshold values.
}
\examples{
# Generate some example data
aGrid <- matrix(c(20, 3, 0, 10, 2, 2, 20, 10, 20),
    nrow = 3, ncol = 3, byrow = TRUE
)
aReq <- matrix(c(15, 5, 0, 0, 5, 5, 10, 10, 15),
    nrow = 3, ncol = 3, byrow = TRUE
)

# Calculate the bin score
binScore(aGrid, aReq)

}
\keyword{binary}
\keyword{scoring}
