% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreData.R
\name{scoreData}
\alias{scoreData}
\title{Predicting new regulatory regions}
\usage{
scoreData(data, ledpred = NULL, model = NULL, score.file = NULL)
}
\arguments{
\item{data}{data.frame containing the test set. This test set must have the same descriptive features as the one that were used to build the model.}

\item{ledpred}{Returned object from the LedPred function}

\item{model}{Returned object of the createModel function}

\item{score.file}{A character string that will be used as the file name for the output file, if it is NULL (default), no file is writen. The output file takes the form of two columns with object names and scores.}
}
\value{
A 2-columns dataframe. First column containg the SVM model prediction probabilities and the second containing the corresponding regions
}
\description{
\code{scoreData} function predict new regulatory regions using SVM model from a test data set
}
\examples{
data(crm.features)
data(svm.model)
#pred.test <- scoreData(data.granges=crm.features, model=svm.model,
# score.file="test_prediction.tab")
}

