% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createModel.R
\name{createModel}
\alias{createModel}
\title{Create the model with the optimal features}
\usage{
createModel(data, cl = 1, kernel = "radial", cost = 1, gamma = 1,
  valid.times = 10, feature.ranking = NULL, feature.nb = NULL,
  file.prefix = NULL)
}
\arguments{
\item{data}{data.frame containing the training set}

\item{cl}{integer indicating the column number corresponding to the response vector that classify positive and negative regions (default = 1)}

\item{kernel}{SVM kernel, a character string: "linear" or "radial". (default = "radial")}

\item{cost}{The SVM cost parameter for both linear and radial kernels. If NULL (default), the function \code{mcTune} is run.}

\item{gamma}{The SVM gamma parameter for radial kernel. If radial kernel and NULL (default), the function \code{mcTune} is run.}

\item{valid.times}{Integer indicating how many times the training set will be split for the cross validation step (default = 10). This number must be smaller than positive and negative sets sizes.}

\item{feature.ranking}{List of ordered features.}

\item{feature.nb}{the optimal number of feature to use from the list of ordered features.}

\item{file.prefix}{A character string that will be used as a prefix followed by "_model.RData" for the resulting model file, if it is NULL (default), no model is saved}
}
\value{
the best SVM model
}
\description{
\code{createModel} function creates a SVM model from the training data set with the selected features.
}
\examples{
    data(crm.features)
    cost <- 1
    gamma <- 1
    data(feature.ranking)
    feature.nb <- 70
#svm.model <- createModel(data.granges=crm.features, cost=cost, gamma=gamma,
#    feature.ranking=feature.ranking, feature.nb=feature.nb)
#feature.weights <- as.data.frame(t(t(svm.model$coefs) \%*\% svm.model$SV))
}

