% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRcell.R
\name{LRcellCore}
\alias{LRcellCore}
\title{Find most enriched cell types in bulk DE genes by Logistic Regression}
\usage{
LRcellCore(gene.p, marker.g, method, min.size = 5, sig.cutoff = 0.05)
}
\arguments{
\item{gene.p}{Named vector of gene-level pvalues from DEG analysis, i.e.
DESeq2, LIMMA}

\item{marker.g}{List of Cell-type specific marker genes derived from
single-cell RNA-seq. The name of the list is cell-type or cluster name, the
values are marker genes vectors or numeric named vectors. LRcell provides
marker genes list in different human/mouse brains, but users could use their
own marker gene list as input.
default: NULL}

\item{method}{Either `logistic regression` or `linear regression`. Logistic
regression equally treats cell-type specific marker genes, however, if
certain values could determine the importance of marker genes, linear
regression can be performed, default: LR.}

\item{min.size}{Minimal size of a marker gene set, will impact the balance of
labels}

\item{sig.cutoff}{Cutoff for input genes' pvalues, default: 0.05.}
}
\value{
A dataframe of LRcell statistics as described in \code{\link{LRcell}}.
}
\description{
This is a function which takes marker genes from single-cell RNA-seq as
reference to calculate the enrichment of certain cell types in bulk DEG
analysis. We assume that bulk DEG is derived from certain cell-type specific
pattern.
}
\examples{
data(mouse_FC_marker_genes)
data(example_gene_pvals)
res <- LRcellCore(example_gene_pvals, mouse_FC_marker_genes, method="LR")
}
