% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postEnrichment.R
\name{plotTopLOLAEnrichments}
\alias{plotTopLOLAEnrichments}
\title{Given some results (you grab the top ones on your own), 
this plots a barplot visualizing their odds ratios.}
\usage{
plotTopLOLAEnrichments(data)
}
\arguments{
\item{data}{A results table returned from runLOLA()}
}
\value{
Returns a ggplot2 plot object.
}
\description{
Given some results (you grab the top ones on your own), 
this plots a barplot visualizing their odds ratios.
}
\examples{
dbPath = system.file("extdata", "hg19", package="LOLA")
regionDB = loadRegionDB(dbLocation=dbPath)
data("sample_universe", package="LOLA")
data("sample_input", package="LOLA")

getRegionSet(regionDB, collections="ucsc_example", filenames="vistaEnhancers.bed")
getRegionSet(dbPath, collections="ucsc_example", filenames="vistaEnhancers.bed")
getRegionFile(dbPath, collections="ucsc_example", filenames="vistaEnhancers.bed")


res = runLOLA(userSets, userUniverse, regionDB, cores=1)
locResult = res[2,]
extractEnrichmentOverlaps(locResult, userSets, regionDB)
writeCombinedEnrichment(locResult, "temp_outfolder")

userSetsRedefined =	redefineUserSets(userSets, userUniverse)
resRedefined = runLOLA(userSetsRedefined, userUniverse, regionDB, cores=1)

g = plotTopLOLAEnrichments(resRedefined)

}
