% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readVCF.R
\name{readVCF}
\alias{readVCF}
\title{Import a VCF file and extract read count}
\usage{
readVCF(
  vcf = NULL,
  ignore.XY = TRUE,
  vcf.source = "strelka",
  min.vaf = 0.01,
  min.depth = 30,
  t.sample = NULL,
  info.af = "AF",
  info.dp = "DP",
  filter.value = "PASS",
  filter.biallelic = TRUE,
  filter.indels = TRUE,
  ...
)
}
\arguments{
\item{vcf}{Input indexed VCF file.}

\item{ignore.XY}{Ignore allosomes. Default TRUE}

\item{vcf.source}{Tool used for generating VCF file. Can be \code{strelka} or \code{mutect} or \code{dkfz} or \code{sentieon}}

\item{min.vaf}{Remove variants with vcf below threshold. Default 0.01}

\item{min.depth}{Minimum required depth for a variant to be considered. Default 30.}

\item{t.sample}{Sample name for tumor. Must be same as in VCF. Strelka hardcodes tumor sample name to "TUMOR"}

\item{info.af}{The string encoding the allele frequency field in the FORMAT column. Defaults to \code{AF}and will be ignored if \code{vcf.source} != \code{sentieon}.}

\item{info.dp}{The string encoding the read depth field in the FORMAT column. Defaults to \code{DP}and will be ignored if \code{vcf.source} != \code{sentieon}.}

\item{filter.value}{The FILTER column value for variants that passed the filtering, defaults to PASS}

\item{filter.biallelic}{Remove biallelic variants. Default TRUE}

\item{filter.indels}{Remove indels. Default TRUE}

\item{...}{further arguments and parameters passed to other
LACHESIS functions.}
}
\value{
a data.table with chrom, pos, ref, alt, t_ref_count, t_alt_count, t_depth, t_vaf
}
\description{
Import a VCF file and extract read-count and variant allele frequencies. Currently VCF files generated by \code{mutect2}, \code{strelka2} and \code{dkfz} are supported.
}
\examples{
mutect_vcf <- system.file("extdata", "mutect.somatic.vcf.gz", package = "LACHESIS")
m_data <- readVCF(vcf = mutect_vcf, vcf.source = "mutect", filter.value = ".")
strelka_vcf <- system.file("extdata", "strelka2.somatic.snvs.vcf.gz", package = "LACHESIS")
s_data <- readVCF(vcf = strelka_vcf, vcf.source = "strelka")
dkfz_vcf <- system.file("extdata", "NBE15", "snvs_NBE15_somatic_snvs_conf_8_to_10.vcf", package = "LACHESIS")
d_data <- readVCF(vcf = dkfz_vcf, vcf.source = "dkfz")
}
