% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LACHESIS.R
\name{plotSurvival}
\alias{plotSurvival}
\title{Correlate SNV density timing at MRCA with Survival}
\usage{
plotSurvival(
  lachesis = NULL,
  mrca.cutpoint = NULL,
  output.dir = NULL,
  surv.time = "OS.time",
  surv.event = "OS",
  surv.palette = c("dodgerblue", "dodgerblue4"),
  surv.time.breaks = NULL,
  surv.time.scale = 1,
  surv.title = "Survival probability",
  surv.ylab = "Survival"
)
}
\arguments{
\item{lachesis}{output generated from \code{\link{LACHESIS}}.}

\item{mrca.cutpoint}{optional, MRCA density value to be used for survival
stratification, will be computationally inferred to maximize survival
differences if not specified by user.}

\item{output.dir}{link to directory in which output is to be stored.}

\item{surv.time}{column name containing survival time; defaults to \code{OS.time}.}

\item{surv.event}{column name containing event; defaults to \code{OS}.}

\item{surv.palette}{color palette to be used. Allowed values include "hue"
for the default hue color scale; "grey" for grey color palettes; brewer
palettes e.g. "RdBu", "Blues", ...; or custom color palette e.g.
c("blue", "red").}

\item{surv.time.breaks}{numeric value controlling time axis breaks; defaults
to \code{NULL}.}

\item{surv.time.scale}{numeric value by which survival time is to be divided
(e.g., 365 for converting days into years, 30 for months), defaults to \code{1}.}

\item{surv.title}{main title.}

\item{surv.ylab}{y-axis label, defaults to \code{Survival}.}
}
\value{
survival graphs
}
\description{
Takes SNV density timing as computed by \code{LACHESIS} as input and compares
survival between tumors with high and low SNV densities
}
\examples{
# An example file with sample annotations and meta data
input.files <- system.file("extdata", "Sample_template.txt",
    package =
        "LACHESIS"
)
input.files <- data.table::fread(input.files)

# cnv and snv files for example tumors
nbe11 <- list.files(system.file("extdata/NBE11/", package = "LACHESIS"),
    full.names = TRUE
)
nbe15 <- list.files(system.file("extdata/NBE15/", package = "LACHESIS"),
    full.names = TRUE
)
nbe26 <- list.files(system.file("extdata/NBE26/", package = "LACHESIS"),
    full.names = TRUE
)

cnv.file <- c(nbe11[1], nbe15[1], nbe26[1])
snv.file <- c(nbe11[2], nbe15[2], nbe26[2])

input.files$cnv.file <- cnv.file
input.files$snv.file <- snv.file

# Make an example input file with paths to cnv and snv file along with other
# meta data
lachesis_input <- tempfile(
    pattern = "lachesis", tmpdir = tempdir(),
    fileext = ".tsv"
)
data.table::fwrite(x = input.files, file = lachesis_input, sep = "\t")

# Example with template file with paths to multiple cnv/snv files as an input
lachesis <- LACHESIS(input.files = lachesis_input)
plotSurvival(lachesis,
    surv.time = "EFS.time", surv.event = "EFS",
    mrca.cutpoint = 0.05
)

}
