% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LACHESIS.R
\name{plotClinicalCorrelations}
\alias{plotClinicalCorrelations}
\title{Correlate SNV density at ECA/MRCA with clinical parameters such as age, OS,
etc.}
\usage{
plotClinicalCorrelations(
  lachesis = NULL,
  clin.par = "Age",
  clin.suppress.outliers = FALSE,
  clin.log.densities = FALSE,
  output.file = NULL
)
}
\arguments{
\item{lachesis}{output generated from \code{\link{LACHESIS}}.}

\item{clin.par}{the clinical parameter used for correlation. Default \code{Age}.}

\item{clin.suppress.outliers}{shall outliers (defined as the 2.5\% tumors with
lowest and highest densities) be plotted? Default \code{TRUE}.}

\item{clin.log.densities}{plot logarithmic densities. Default \code{FALSE}.}

\item{output.file}{optional; the file to which the plot will be stored.}
}
\value{
graph with SNV density at ECA/ MRCA copared to clinical parameters
}
\description{
Takes SNV densities as computed by \code{LACHESIS} as input and correlates them
with clinical data such as age at diagnosis, survival data etc.
}
\examples{
# An example file with sample annotations and meta data
input.files <- system.file("extdata", "Sample_template.txt",
    package = "LACHESIS"
)
input.files <- data.table::fread(input.files)

# cnv and snv files for example tumors
nbe11 <- list.files(system.file("extdata/NBE11/", package = "LACHESIS"),
    full.names = TRUE
)
nbe15 <- list.files(system.file("extdata/NBE15/", package = "LACHESIS"),
    full.names = TRUE
)
nbe26 <- list.files(system.file("extdata/NBE26/", package = "LACHESIS"),
    full.names = TRUE
)

cnv.file <- c(nbe11[1], nbe15[1], nbe26[1])
snv.file <- c(nbe11[2], nbe15[2], nbe26[2])

input.files$cnv.file <- cnv.file
input.files$snv.file <- snv.file

# Make an example input file with paths to cnv and snv file along with other
# meta data
lachesis_input <- tempfile(
    pattern = "lachesis", tmpdir = tempdir(),
    fileext = ".tsv"
)
data.table::fwrite(x = input.files, file = lachesis_input, sep = "\t")

# Example with template file with paths to multiple cnv/snv files as an input
lachesis <- LACHESIS(input.files = lachesis_input)
plotClinicalCorrelations(lachesis)
}
