% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateClonality.R
\name{estimateClonality}
\alias{estimateClonality}
\title{Assigning clonality status to every SNV}
\usage{
estimateClonality(
  nbObj = NULL,
  mrcaObj = NULL,
  ID = NULL,
  purity = NULL,
  driver.file = NULL,
  ref.build = "hg19"
)
}
\arguments{
\item{nbObj}{combined SNV and CNV information as generated by
\code{\link{nbImport}}.}

\item{mrcaObj}{clonal SNV counts stratified by copy number as generated by
\code{\link{MRCA}}.}

\item{ID}{sample name.}

\item{purity}{tumor cell content.}

\item{driver.file}{optional, path to file with "chrom", "snv_start", "ref",
"alt", "gene" column containing known driver SNVs.}

\item{ref.build}{Reference genome. Default \code{hg19}. Can be \code{hg18}, \code{hg19} or
\code{hg38}.}
}
\value{
a data.table with per-SNV clonality assignment
}
\description{
Assigns clonality status to every SNV based on the variant allele frequency
distribution. The function uses maximum a posteriori assignment of single
variants to either "subclonal", "clonal", "early clonal" or "late clonal"
(if distinguishable). The likelihood is computed according to a binomial
distribution; prior probabilities are empirically determined based on the
relative SNV burden per clonal state.
}
\examples{
# Example using variants associated with specific SBS mutational signatures
# from vcf file
snvs <- system.file("extdata", "NBE15",
    "snvs_NBE15_somatic_snvs_conf_8_to_10.vcf",
    package = "LACHESIS"
)
s_data <- readVCF(vcf = snvs, vcf.source = "dkfz")
aceseq_cn <- system.file("extdata", "NBE15",
    "NBE15_comb_pro_extra2.51_1.txt",
    package = "LACHESIS"
)
c_data <- readCNV(aceseq_cn)
sig.filepath <- system.file("extdata",
    "NBE15_Decomposed_MutationType_Probabilities.txt",
    package = "LACHESIS"
)
nb <- nbImport(
    cnv = c_data, snv = s_data, purity = 1, ploidy = 2.51,
    sig.assign = TRUE, ID = "NBE15", sig.file = sig.filepath
)
cl_muts <- clonalMutationCounter(nb)
norm_muts <- normalizeCounts(cl_muts)
mrca <- MRCA(norm_muts)
estimateClonality(nbObj = nb, mrcaObj = mrca, ID = "NBE15", purity = 1)

}
