% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LACEview2.R
\name{lace_interface}
\alias{lace_interface}
\title{LACE Interface}
\usage{
lace_interface(
  B_mat,
  clones_prevalence,
  C_mat,
  error_rates,
  width = NULL,
  height = NULL,
  elementId = NULL,
  info = ""
)
}
\arguments{
\item{B_mat}{(Required). B is the clonal tree matrix where columns are the
clonal mutations and and rows are the clones. The clonal tree matrix should
contain a column and a row named "Root" representing the root of the tree and
the wild type, respectively.
B is a binary matrix where 1 are the mutations associated to the clones.
The wild type column has all ones}

\item{clones_prevalence}{(Required) The clonal prevalence matrix}

\item{C_mat}{(Required) The corrected clonal attachment}

\item{error_rates}{(Required) The false positive alpha and false negative beta
error rates used to infer the clonal tree}

\item{width}{(optional) Size of the window interafce}

\item{height}{(optional) Size of the window interafce}

\item{elementId}{(optional) Element id}

\item{info}{(Optional). HTML formatted text with information regarding
the experiments}
}
\value{
An implementation of the htmlwidgets
}
\description{
This function generates a longitudinal clonal tree and a
graphic interface to explore the data using as input the clonal tree
formatted in the same way as the one produced by LACE during the imputation
steps
}
