% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn_test.R
\name{knn_test}
\alias{knn_test}
\title{knn_test allows assessing the final DEGs through a machine learning step by using k-NN with a test dataset.}
\usage{
knn_test(train, labelsTrain, test, labelsTest, vars_selected, bestK)
}
\arguments{
\item{train}{The train parameter is an expression matrix or data.frame that contains the train dataset with the genes in the columns and the samples in the rows.}

\item{labelsTrain}{A vector or factor that contains the train labels for each of the samples in the train object.}

\item{test}{The test parameter is an expression matrix or data.frame that contains the test dataset with the genes in the columns and the samples in the rows.}

\item{labelsTest}{A vector or factor that contains the test labels for each of the samples in the test object.}

\item{vars_selected}{The genes selected to classify by using them. It can be the final DEGs extracted with the function \code{\link{DEGsExtraction}} or a custom vector of genes. Furthermore, the ranking achieved by \code{\link{featureSelection}} function can be used as input of this parameter.}

\item{bestK}{Best K selected during the training phase.}
}
\value{
A list that contains six objects. The confusion matrix for each fold, the accuracy, the sensitivity, the specificity and the F1-Scores for each gene, and the predictions made.
}
\description{
knn_test allows assessing the final DEGs through a machine learning step by using k-NN with a test dataset. An optimization of the k neighbours is done at the start of the process.
}
\examples{
dir <- system.file("extdata", package="KnowSeq")
load(paste(dir,"/expressionExample.RData",sep = ""))

trainingMatrix <- t(DEGsMatrix)[c(1:4,6:9),]
trainingLabels <- labels[c(1:4,6:9)]
testMatrix <- t(DEGsMatrix)[c(5,10),]
testLabels <- labels[c(5,10)]
bestK <- 3 # the one that has been selected
results_test_knn <- knn_test(trainingMatrix, trainingLabels, testMatrix, testLabels, rownames(DEGsMatrix)[1:10], bestK)
}
