% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countsToMatrix.R
\name{countsToMatrix}
\alias{countsToMatrix}
\title{countsToMatrix merges in a matrix the information in the count files.}
\usage{
countsToMatrix(csvFile, sep = ",", extension = "")
}
\arguments{
\item{csvFile}{The csv that contains the name and the path to each of the count files. The column of the name of the file must be named Run and the column that contains the paths must be named Path. Furthermore, to facilitate the posterior steps, a column named Class that contains the classes for the samples must be required.}

\item{sep}{The separator character of the csvFile or tsvFile.}

\item{extension}{The extension of the count file. Set to count by default.}
}
\value{
A matrix with the ensembl ID in the rows and all the samples of each count files in the columns.
}
\description{
The function merges in a matrix the information in the count files. It can be used from 1 to N count files. These count files can be created by using the function \code{\link{rawAlignment}} with the raw files of RNA-seq.
}
\examples{
dir <- system.file("extdata", package="KnowSeq")
countsInfo <- read.csv(paste(dir,"/countFiles/mergedCountsInfo.csv",sep = ""))

countsInfo$Path <- paste(dir,"/countFiles/",countsInfo$Run,sep = "")

write.csv(countsInfo, file = "countsInfo.csv")

countsInformation <- countsToMatrix("countsInfo.csv", extension = 'count')

countsMatrix <- countsInformation$countsMatrix
labels <- countsInformation$labels

file.remove("countsInfo.csv")
}
