% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_edge.R
\name{tidy_edge}
\alias{tidy_edge}
\title{Tidy up pathway by combining edges inside of edge_mapping_info}
\usage{
tidy_edge(edges, edge_id, data_added = FALSE, by_significance = FALSE,
  by_number = TRUE)
}
\arguments{
\item{edges}{The edge dataframe}

\item{edge_id}{The numeric value for the edge_id}

\item{data_added}{A logical indicator; set to TRUE if data is added}

\item{by_significance}{A logical indicator; option if data is added}

\item{by_number}{A logical indicator; gives rough estimate of edge amount}
}
\value{
A data frame that has had the given edge condensed for viewing
}
\description{
Combine edges that share nodes and have other commonalities
}
\examples{
\dontrun{
if (tidy_edge == TRUE) {
   edge_IDs <- seq(min(expanded_edges$edgeID), max(expanded_edges$edgeID))
   for (i in edge_IDs){
     if(data_added == TRUE){
       expanded_edges <- tidy_edge(edges = expanded_edges,
                                   edge_id = edge_IDs[i], 
                                   data_added = TRUE,
                                   by_significance = TRUE)
     }
     if(data_added == FALSE){
       expanded_edges <- tidy_edge(edges = expanded_edges,
                                   edge_id = edge_IDs[i], 
                                   data_added = FALSE)
     }
   }

}
}
}
