% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_graph_object.R
\name{get_graph_object}
\alias{get_graph_object}
\title{Generate graph object from nodes and edges}
\usage{
get_graph_object(node_mapping_info, expanded_edges,
  layered_nodes = FALSE)
}
\arguments{
\item{node_mapping_info}{The data.frame object generated by the function 
node_mapping_info()}

\item{expanded_edges}{The data.frame object generated by the function 
edge_mapping_info()}

\item{layered_nodes}{A logical indicator; if set to TRUE will create a 
graph with 'stacked' nodes that the user can manipulate when multiple nodes 
are mapped to one location}
}
\value{
A list object with the node and edge information from the graph 
required for mapping.
}
\description{
Obtain a graph object in the form of an igraph with 
KEGG-specific graphical information
}
\examples{

p53_KGML <- get_KGML("hsa04115")
p53_KEGG_mappings <-  expand_KEGG_mappings(p53_KGML)

p53_node_mapping_info <- node_mapping_info(p53_KEGG_mappings)
p53_edge_mapping_info <- expand_KEGG_edges(p53_KGML, p53_KEGG_mappings)

#Default graph object will have 'expanded edges':
expanded_edges_graph_object <- get_graph_object(p53_node_mapping_info, 
                                                p53_edge_mapping_info)

#Graph with layered nodes:
layered_nodes_graph_object <- get_graph_object(p53_node_mapping_info,
                                               p53_edge_mapping_info, 
                                               layered_nodes = TRUE)
}
