% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KL_compare.R
\name{KL_compare}
\alias{KL_compare}
\title{Combines all other package functions for one-step cell line comparison}
\usage{
KL_compare(pathwayid, cell_line1 = NA, cell_line2 = NA,
  refine_by_cell_line = TRUE, data_type = "100_full", pert_time = 96,
  only_mapped = TRUE, get_data = FALSE, convert_KEGG_IDs = TRUE,
  graph_title = "default", tidy_edge = TRUE, layered_nodes = FALSE)
}
\arguments{
\item{pathwayid}{A KEGG pathway ID of the form "hsa12345" 
(only human pathways currently)}

\item{cell_line1}{Choose from the set of cell lines: 
(A375,A549,ASC,HA1E,HCC515,HEK293T,HEKTE,HEPG2,HT29,MCF7,NCIH716,NPC,PC3,
SHSY5Y,SKL,SW480,VCAP)}

\item{cell_line2}{A cell line such that cell_line1 != cell_line2}

\item{refine_by_cell_line}{A logical indicator}

\item{data_type}{Choose from data types: (100_full, 100_bing, 50_lm)}

\item{pert_time}{Choose from (6,24,48,96,120,144,168)}

\item{only_mapped}{A logical indicator; if set to FALSE will return 'de-novo'
edges that 'exist' in data but are not documented in KEGG}

\item{get_data}{A logical indicator; if set to true, will return the 
'expanded' edge information for the specified pathway}

\item{convert_KEGG_IDs}{A logical indicator; if set to TRUE KEGG 
compounds will remain labeled via KEGG codes (do not need KEGGREST)}

\item{graph_title}{An optional user-specified graph title}

\item{tidy_edge}{A logical indicator; must be set to FALSE for expanded edges}

\item{layered_nodes}{A logical indicator; if set to TRUE will create a graph 
with 'stacked' nodes that the user can manipulate when multiple nodes are 
mapped to one location}
}
\value{
A dynamic map in Cytoscape automatically formatted for convenient 
viewing and, if idicated by user, a data.frame object with detailed 
information for 'expanded' KEGG edges
}
\description{
Combines all other package functions for one-step cell line comparison
}
\examples{
\dontrun{ 

# Compare p53 pathway between cell lines A375 and A549:
KL_compare("hsa04115", "A375", "A549")
}
}
