% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KEGG_lincs.R
\name{KEGG_lincs}
\alias{KEGG_lincs}
\title{Combines all other package functions for one-step pathway visualization}
\usage{
KEGG_lincs(pathwayid, cell_line = NA, refine_by_cell_line = NA,
  add_L1000_edge_data = TRUE, significance_markup = TRUE,
  data_type = "100_full", pert_time = 96, only_mapped = TRUE,
  layered_nodes = FALSE, graph_title = "default", get_data = FALSE,
  convert_KEGG_IDs = TRUE, tidy_edge = FALSE)
}
\arguments{
\item{pathwayid}{A KEGG pathway ID of the form "hsa12345" 
(only human pathways currently)}

\item{cell_line}{If left as NA will generate a pathway map without 
data-dependent attributes (such as edge width).  To use in combination 
with LINCS data, choose from the set of cell lines: 
(A375,A549,ASC,HA1E,HCC515,HEK293T,HEKTE,HEPG2,HT29,MCF7,NCIH716,NPC,PC3,
SHSY5Y,SKL,SW480,VCAP)}

\item{refine_by_cell_line}{A logical indicator}

\item{add_L1000_edge_data}{A logical indicator}

\item{significance_markup}{A logical indicator; if set to TRUE will color
edges based on direction and significance of correlation (as determined by 
user-data-analysis)}

\item{data_type}{Choose from data types: (100_full, 100_bing, 50_lm)}

\item{pert_time}{Choose from (6,24,48,96,120,144,168)}

\item{only_mapped}{A logical indicator; if set to FALSE will return 'de-novo'
edges that 'exist' in data but are not documented in KEGG}

\item{layered_nodes}{A logical indicator; if set to TRUE will create a graph 
with 'stacked' nodes that the user can manipulate when multiple nodes are 
mapped to one location}

\item{graph_title}{An optional user-specified graph title}

\item{get_data}{A logical indicator; if set to true, will return the 
'expanded' edge information for the specified pathway}

\item{convert_KEGG_IDs}{A logical indicator; if set to TRUE KEGG 
compounds will remain labeled via KEGG codes (do not need KEGGREST)}

\item{tidy_edge}{A logical indicator; must be set to FALSE for expanded edges}
}
\value{
A dynamic map in Cytoscape automatically formatted for convenient 
viewing and, if idicated by user, a data.frame object with detailed 
information for 'expanded' KEGG edges
}
\description{
Combines all other package functions for one-step pathway visualization
}
\examples{
\dontrun{ 

#Default KEGG pathway with colored edges representing type of relationship:
KEGG_lincs("hsa04115", convert_KEGG_IDs = FALSE)

#KEGG pathway with edge width and color based on observed experimental data:
KEGG_lincs("hsa04115", "HA1E")

#Have edge information data.frame to be output to the global environment:
p53_edge_info <- KEGG_lincs("hsa04115", graph_title = "p53"
                             convert_KEGG_IDs = FALSE, get_data = TRUE)
                             }
}
