#' Prepare nodes for mapping
#' @description Modify the mapping information for desired look when graphed 
#' in Cytoscape
#' @param KEGG_mappings The data.frame object generated by the function 
#' expand_KEGG_mappings()
#' @return A data.frame object for nodes that will be passed on to the function 
#' get_graph_object
#' @export
#' @examples
#' p53_KGML <- get_KGML("hsa04115")
#' p53_KEGG_mappings <- expand_KEGG_mappings(p53_KGML, FALSE)
#' 
#' p53_node_mapping_info <- node_mapping_info(p53_KEGG_mappings)

node_mapping_info <-
function(KEGG_mappings){
    node_map <- KEGG_mappings
    for (i in (1:nrow(node_map))){
        if (node_map$entryTYPE[i] == "compound" | 
            node_map$entryTYPE[i] == "group"){
            node_map$label_font_size[i] <- 6
        }
        else {
            node_map$label_font_size[i] <- 9
        }
        if (node_map$entryTYPE[i] == "compound"){
            node_map$border_width[i] <- 3
        }
        else if (node_map$entryTYPE[i] == "gene"){
            node_map$border_width[i] <- 1
        }
        else if (node_map$entryTYPE[i] == "group"){
            node_map$border_width[i] <- 3
        }
        else if (node_map$entryTYPE[i] == "map"){
        node_map$border_width[i] <- 1
        }
        else if (node_map$entryTYPE[i] == "ortholog"){
        node_map$border_width[i] <- 1
        }
        if (node_map$entryTYPE[i] == "map"){
            if (substring(node_map$LABEL[i],1,5) == "TITLE"){
                node_map$BGcolor[i] <- "#89b9cE"
                node_map$LABEL[i] <- strsplit(node_map$LABEL[[i]], ":")[[1]][2]
                node_map$shape[i] <- "rectangle"
                node_map$border_width[i] <- 3
                node_map$label_font_size[i] <- 11
            }
            else{
                node_map$BGcolor[i] <- "#b3dddf"
            }
        }
        if (node_map$entryTYPE[i] == "group"){
            node_map$width[i] <-node_map$width[i]+3
            node_map$height[i] <-node_map$height[i]+3
            node_map$entryNAMES[i] <- 
                toString(unlist(node_map$entrySYMBOL[[i]]))
            node_map$entrySYMBOL[i] <- 
                toString(unlist(node_map$entrySYMBOL[[i]]))
            node_map$entryACCESSION[i] <- 
                toString(unlist(node_map$entryACCESSION[[i]]))
        }
    }
    node_density <- data.frame(table(node_map$entryID), 
                            stringsAsFactors = FALSE)
    for (i in 1:nrow(node_map)){
        node_map$node_density[i] <- 
            node_density$Freq[node_density[,1] == node_map$entryID[i]]
    }
    return(node_map)
}
