% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_summary_bin.R
\name{net_summary_bin}
\alias{net_summary_bin}
\title{Function to summarize the GRN filtered with a threshold,}
\usage{
net_summary_bin(GRN, TFs, thr, a, b)
}
\arguments{
\item{GRN}{An inferred network}

\item{TFs}{A vector with indexes of the rows of GRN which correspond to TFs.}

\item{thr}{a scalar between 0 and 1, a threshold for posterior probabilities.}

\item{a}{parameter for Katz and PageRank centrality (default the inverse of the largest eigenvalue of GRN.}

\item{b}{parameter for Katz and PageRank centrality (default b = 1).}
}
\value{
list with table version of the GRN, outdegree and indegree, and closeness centrality.
}
\description{
Function to summarize the GRN filtered with a threshold,
}
\examples{
data(D4_multi_1)
Net = kboost(D4_multi_1)
Net_Summary = net_summary_bin(Net$GRN)

}
