% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRTargets_Stat.r
\name{miRTargets_Stat}
\alias{miRTargets_Stat}
\title{Extracting miRNAs that target a query gene.}
\usage{
miRTargets_Stat(
  miR,
  method = c("Pearson", "Distance", "Both", "BothIntersect"),
  Platform = c("Affy1", "Affy2"),
  outpath = tempdir(),
  Text = FALSE
)
}
\arguments{
\item{miR}{character. miRNA symbol.}

\item{method}{character. Choices are "Pearson", "Distance","Both" 
and "BothIntersected"}

\item{Platform}{character. Choices are "Affy1","Affy2".}

\item{outpath}{character. The path where the data is stored if TEXT=TRUE.
Default is tempdir().}

\item{Text}{logical . To choose between storing the data as text file.
Default is FALSE.}
}
\value{
Outputs the target information, Target Prediction Score, miRNA 
        target function and Target Database that predicts the interaction in
        a dataframe.
        Depending upon the ouput choice data is stored in the
        path specified. Default option prints output to the console.
}
\description{
Extracting miRNAs that target a query gene.
}
\examples{
miRNA="dme-miR-12"
miRTargets_Stat (miRNA,method=c ("Pearson"),Platform=c ("Affy1"),Text=FALSE)
}
