% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gene_Visualisation.r
\name{Gene_Visualisation}
\alias{Gene_Visualisation}
\title{Visualises the targetGene:miRNA network using Cytoscape and igraph .}
\usage{
Gene_Visualisation(
  mRNA,
  mRNA_type = c("GeneSymbol", "FBGN", "CGID"),
  method = c("Pearson", "Distance", "Both"),
  platform = c("Affy1", "Affy2"),
  visualisation = c("igraph", "Cytoscape", "text", "console"),
  path = tempdir(),
  layout = c("kamadakawai", "reingold.tilford", "fruchterman.reingold", "interactive")
)
}
\arguments{
\item{mRNA}{character. gene Identifier.}

\item{mRNA_type}{character. mRNA id type.
The choices are 'GeneSymbol','FBID' and 'CGID'.}

\item{method}{character. Statistical Methods. Choices are
'Pearson','Distance','Both'}

\item{platform}{character. Affymetrix Platforms. Choices are
'Affy1','Affy2'.}

\item{visualisation}{character.Visualisation type.
Choices are 'igraph','Cytoscape','text'and "console"}

\item{path}{character. Path where data.frame is saved when visualisation
is text. Default is tempdir().}

\item{layout}{character. Network choices. Choices are
'kamadakawai','reingold.tilford','fruchterman.reingold' 
  and 'interactive'.}
}
\value{
Depending upon the ouput choice network image or dataframe 
        containg miRNAs that target the query gene are ouput.
}
\description{
Visualises the targetGene:miRNA network using Cytoscape and igraph .
}
\examples{
mRNA='Syb'
Gene_Visualisation(mRNA,mRNA_type=c('GeneSymbol'),method=c('Pearson'),
                  platform=c('Affy1'), visualisation = "console")
}
