\docType{methods}
\name{boxplot-method}
\alias{intexBoxplot}
\alias{boxplot,SummarizedExperiment-method}
\alias{boxplot-method}

\title{
	boxplot - method
}
\description{
	boxplot method for \code{SummarizedExperiment} objects.
}
\usage{
\S4method{boxplot}{SummarizedExperiment}(x, sampleAnnoCol=NA, 
	intexTypeCol="int_type", intexType=c(), col="white", boxplotNames=c(), 
	lasNames=3, outline=FALSE, addGrid=FALSE, ...)
}
\arguments{
\item{x}{ 
	Object of type \code{SummarizedExperiment} generated by either  
	\code{interest()},  \code{interest.sequential()} or  
	\code{readInterestResults()}.
}
\item{sampleAnnoCol}{
Which colummn of \code{colData} in \code{x} to consider for plotting.
}
\item{intexTypeCol}{
Column name (or number) that represents what type of intron/exon each row of 
\code{x} assays represents.
}
\item{intexType}{
A vector of characters describing types of introns/exons to be plotted. They 
must be elements in the \code{intexTypeCol} column of the rowData of \code{x}. 
rowData of \code{x} is a dataframe that includes various annotations of the
introns/exons.
}
\item{col}{
Vector showing box colours. It is either of size 1 or the same size as the 
number of groups to be plotted.
}
\item{boxplotNames}{
Names to write under boxes. If not defined, as names, it pastes the row 
(intron/exon) annotation names to the sample group annotations separated by a
space " ".
}
\item{lasNames}{
Orientation of the box names.
}
\item{outline}{
If outline is TRUE the outlier points are drawn otherwise if FALSE (default) 
they are not.
}
\item{addGrid}{ 
Whether add a grid under the boxplots (FALSE by default). 
}
\item{...}{
Other arguments to pass to the \code{boxplot()} and \code{axis} function.
}

}
\value{
	Returns NULL.
}
\seealso{
Class:
	\code{\link[SummarizedExperiment]{SummarizedExperiment-class}}
Method:
	 \code{\link{counts-method}}
	\code{\link{plot-method}}
}
\author{Ali Oghabian}

\examples{

#Plotting U12- vs U2-type introns
par(mar=c(8,4,2,1))
boxplot(x=mdsChr22Obj, sampleAnnoCol="type", intexTypeCol="intron_type", 
	intexType=c("U2", "U12"), 
	col=rep(c("yellow", "orange"),3), 
	boxplotNames=c(), lasNames=3, outline=FALSE, 
	addGrid=TRUE)

}

