% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretization.plugin.R
\name{discretize2d.uniform_width}
\alias{discretize2d.uniform_width}
\title{Discretize two sets of continuous data into 2-dimensional bins by "uniform width" method}
\usage{
discretize2d.uniform_width(x, y)
}
\arguments{
\item{x}{a numeric vector of the first random variable.}

\item{y}{a numeric vector of the second random variable.}
}
\value{
discretize2d.uniform_width returns a 2-dimensional count table.
}
\description{
discretize2d.uniform_width assigns the observations of two continuous random variables to bins according to the "uniform width" method,
and returns a corresponding 2-dimensional count table.
}
\details{
Uniform width-based method ("uniform_width") divides the continuous data into N bins with equal width.
The number of bins N is initialized into a round-off value according to the square root of the data size.
}
\examples{
# two numeric vectors corresponding to two continuous random variables
x <- c(0.0, 0.2, 0.2, 0.7, 0.9, 0.9, 0.9, 0.9, 1.0)
y <- c(1.0, 2.0,  12, 8.0, 1.0, 9.0, 0.0, 3.0, 9.0)

# corresponding joint count table estimated by "uniform width" algorithm
discretize2d.uniform_width(x,y)
}
