% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretization.plugin.R
\name{discretize1d.uniform_width}
\alias{discretize1d.uniform_width}
\title{Discretize a set of continuous data into 1-dimensional bins by "uniform width" method}
\usage{
discretize1d.uniform_width(x)
}
\arguments{
\item{x}{a numeric vector of a random variable.}
}
\value{
discretize1d.uniform_width returns a count table.
}
\description{
discretize1d.uniform_width assigns the observations of continuous random variables to bins according to the "uniform width" method,
and returns a corresponding count table.
}
\details{
Uniform width-based method ("uniform_width") divides the continuous data into N bins with equal width.
The number of bins N is initialized into a round-off value according to the square root of the data size.
}
\examples{
# a numeric vector corresponding to a continuous random variable
x <- c(0.0, 0.2, 0.2, 0.7, 0.9, 0.9, 0.9, 0.9, 1.0)

# corresponding count table estimated by "uniform width" algorithm
discretize1d.uniform_width(x)
}
