% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCorrelation.R
\name{plotCorrelation}
\alias{plotCorrelation}
\title{Function to plot correlation}
\usage{
plotCorrelation(obj, sId, geneName, xLabel = "Gene expression",
  yLabel = "Signal enrichment", colByPhenotype = "",
  corMethod = "pearson")
}
\arguments{
\item{obj}{InTADSig object with signals and genes combined in TADS}

\item{sId}{Signal id based on genomic cooridantes i.e. "chr:start-end"}

\item{geneName}{Gene name to select. Based on "gene_name" attribute.}

\item{xLabel}{The label to mark signal X-axis. Default: "Gene expression"}

\item{yLabel}{The label to mark signal Y-axis. Default: "Signal enrichment"}

\item{colByPhenotype}{The pheno data column i.e. tumour type
that can be use for colour}

\item{corMethod}{Correlation method. Default: Pearson}
}
\value{
A \code{ggplot} object for visualization or customization.
}
\description{
This function creates a plot of selected pair signal-gene
}
\examples{
inTadSig <- newSigInTAD(enhSel, enhSelGR, rpkmCountsSel, txsSel)
inTadSig <- combineInTAD(inTadSig, tadGR)
plotCorrelation(inTadSig, "chr15:26372163-26398073", "GABRA5")

}
