% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCorrelation.R
\name{plotCorAcrossRef}
\alias{plotCorAcrossRef}
\title{Function to plot correlation across genome}
\usage{
plotCorAcrossRef(obj, corRes, targetRegion, showCorVals = FALSE,
  symmetric = FALSE, tads = NULL)
}
\arguments{
\item{obj}{InTADSig object with signals and genes combined in TADS}

\item{corRes}{Correlation result table created by function findCorrelation()}

\item{targetRegion}{Target genomic region visualise.}

\item{showCorVals}{Use this option to visualize postive correlation values
instead of correlation strength}

\item{symmetric}{Activate mirrow symmetry for gene-signal connections}

\item{tads}{TAD regions to visualize. By default only TADs persent in
correlation result table are applied (NULL value).}
}
\value{
A \code{ggplot} object for visualization or customization.
}
\description{
This function creates a plot of correlation strength
in target genomic region from the result table.
The X-coordinates represent signals, Y-coords represent genes, while
each dot represents -log10(P-value) from correlation test.
Additionallly all TAD boundaries can be visualized.
}
\examples{
inTadSig <- newSigInTAD(enhSel, enhSelGR, rpkmCountsSel, txsSel)
inTadSig <- combineInTAD(inTadSig, tadGR)
corData <- findCorrelation(inTadSig, method="pearson")
plotCorAcrossRef(inTadSig,corData,GRanges("chr15:25000000-28000000"))

}
