% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineExpandedBCR.R
\name{combineExpandedBCR}
\alias{combineExpandedBCR}
\title{combineBCR for CDR1/2/3 sequences}
\usage{
combineExpandedBCR(
  input.data,
  samples = NULL,
  ID = NULL,
  call.related.clones = TRUE,
  threshold = 0.85,
  removeNA = FALSE,
  removeMulti = FALSE,
  filterMulti = TRUE,
  filterNonproductive = TRUE
)
}
\arguments{
\item{input.data}{List of filtered contig annotations.}

\item{samples}{Character vector. Labels of samples (required).}

\item{ID}{Character vector. Additional sample labeling (optional).}

\item{call.related.clones}{Logical. Whether to call related clones based on
nucleotide sequence and V gene. Default is \code{TRUE}.}

\item{threshold}{Numeric. Normalized edit distance for clone clustering.
Default is \code{0.85}.}

\item{removeNA}{Logical. Whether to remove any chain without values. Default
is \code{FALSE}.}

\item{removeMulti}{Logical. Whether to remove barcodes with more than two
chains. Default is \code{FALSE}.}

\item{filterMulti}{Logical. Whether to select the highest-expressing light
and heavy chains. Default is \code{TRUE}.}

\item{filterNonproductive}{Logical. Whether to remove nonproductive chains.
Default is \code{TRUE}.}
}
\value{
A list of consolidated BCR clones with expanded CDR sequences.
}
\description{
This function enhances BCR processing by incorporating additional
sequence information from CDR1 and CDR2 regions before applying the BCR
combination logic. The function depends on
\code{\link[scRepertoire:combineBCR]{scRepertoire::combineBCR()}}.
}
\examples{
#' # Get Data
ibex_vdj <- get(data("ibex_vdj"))

combined.BCR <- combineExpandedBCR(list(ibex_vdj),
                                   samples = "Sample1",
                                   filterNonproductive = TRUE)

}
\seealso{
\code{\link[scRepertoire:combineBCR]{scRepertoire::combineBCR()}}
}
