% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-functions.R
\name{separate_quant_matrices}
\alias{separate_quant_matrices}
\title{Separate a multiple-quantification matrix into single quantification
matrices.}
\usage{
separate_quant_matrices(
  x,
  fragmentEstimate = "fragmentEstimate",
  seqCount = "seqCount",
  barcodeCount = "barcodeCount",
  cellCount = "cellCount",
  ShsCount = "ShsCount",
  key = c(mandatory_IS_vars(), annotation_IS_vars(), "CompleteAmplificationID")
)
}
\arguments{
\item{x}{Single integration matrix with multiple quantification
value columns, obtained via \link{comparison_matrix}.}

\item{fragmentEstimate}{Name of the fragment estimate values column
in input}

\item{seqCount}{Name of the sequence count values column
in input}

\item{barcodeCount}{Name of the barcode count values column
in input}

\item{cellCount}{Name of the cell count values column
in input}

\item{ShsCount}{Name of the shs count values column
in input}

\item{key}{Key columns to perform the joining operation}
}
\value{
A named list of data frames, where names are quantification types
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
The function separates a single multi-quantification integration
matrix, obtained via \link{comparison_matrix}, into single
quantification matrices as a named list of tibbles.
}
\examples{
data("integration_matrices", package = "ISAnalytics")
separated <- separate_quant_matrices(
    integration_matrices
)
}
\seealso{
\link{quantification_types}

Other Utilities: 
\code{\link{as_sparse_matrix}()},
\code{\link{comparison_matrix}()},
\code{\link{enable_progress_bars}()},
\code{\link{export_ISA_settings}()},
\code{\link{generate_Vispa2_launch_AF}()},
\code{\link{generate_blank_association_file}()},
\code{\link{generate_default_folder_structure}()},
\code{\link{import_ISA_settings}()},
\code{\link{transform_columns}()}
}
\concept{Utilities}
