% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis-functions.R
\name{sample_statistics}
\alias{sample_statistics}
\title{Computes user specified functions on numerical columns and updates
the metadata data frame accordingly.}
\usage{
sample_statistics(
  x,
  metadata,
  sample_key = "CompleteAmplificationID",
  value_columns = "Value",
  functions = default_stats(),
  add_integrations_count = TRUE
)
}
\arguments{
\item{x}{A data frame}

\item{metadata}{The metadata data frame}

\item{sample_key}{Character vector representing the key for identifying
a sample}

\item{value_columns}{The name of the columns to be computed,
must be numeric or integer}

\item{functions}{A named list of function or purrr-style lambdas}

\item{add_integrations_count}{Add the count of distinct integration sites
for each group? Can be computed only if \code{x} contains the mandatory columns
\code{mandatory_IS_vars()}}
}
\value{
A list with modified x and metadata data frames
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
The function operates on a data frame by grouping the content by
the sample key and computing every function specified on every
column in the \code{value_columns} parameter. After that the metadata
data frame is updated by including the computed results as columns
for the corresponding key.
For this reason it's required that both \code{x} and \code{metadata} have the
same sample key, and it's particularly important if the user is
working with previously aggregated data.
For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
aggreg <- aggregate_values_by_key(
 x = integration_matrices,
 association_file = association_file,
 value_cols = c("seqCount", "fragmentEstimate")
)
aggreg_meta <- aggregate_metadata(association_file = association_file)

sample_stats <- sample_statistics(x = aggreg,
metadata = aggreg_meta,
value_columns = c("seqCount", "fragmentEstimate"),
sample_key = c("SubjectID", "CellMarker","Tissue", "TimePoint"))

}\if{html}{\out{</div>}}
}
\section{Required tags}{

The function will explicitly check for the presence of these tags:
\itemize{
\item All columns declared in \code{mandatory_IS_vars()}
}

These are checked only if \code{add_integrations_count = TRUE}.
}

\examples{
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
stats <- sample_statistics(
    x = integration_matrices,
    metadata = association_file,
    value_columns = c("seqCount", "fragmentEstimate")
)
stats
}
\seealso{
Other Analysis functions: 
\code{\link{CIS_grubbs}()},
\code{\link{HSC_population_size_estimate}()},
\code{\link{compute_abundance}()},
\code{\link{cumulative_is}()},
\code{\link{gene_frequency_fisher}()},
\code{\link{is_sharing}()},
\code{\link{iss_source}()},
\code{\link{top_integrations}()},
\code{\link{top_targeted_genes}()}
}
\concept{Analysis functions}
