% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-functions.R
\name{export_ISA_settings}
\alias{export_ISA_settings}
\title{Export a dynamic vars settings profile.}
\usage{
export_ISA_settings(folder, setting_profile_name)
}
\arguments{
\item{folder}{The path to the folder where the file should be saved. If
the folder doesn't exist, it gets created automatically}

\item{setting_profile_name}{A name for the settings profile}
}
\value{
\code{NULL}
}
\description{
This function allows exporting the currently set dynamic
vars in json format so it can be quickly imported later. Dynamic
variables need to be properly set via the setter functions before calling
the function. For more details, refer to the dedicated vignette
\code{vignette("workflow_start", package="ISAnalytics")}.
}
\examples{
tmp_folder <- tempdir()
export_ISA_settings(tmp_folder, "DEFAULT")
}
\seealso{
Other Utilities: 
\code{\link{as_sparse_matrix}()},
\code{\link{comparison_matrix}()},
\code{\link{enable_progress_bars}()},
\code{\link{generate_Vispa2_launch_AF}()},
\code{\link{generate_blank_association_file}()},
\code{\link{generate_default_folder_structure}()},
\code{\link{import_ISA_settings}()},
\code{\link{separate_quant_matrices}()},
\code{\link{transform_columns}()}
}
\concept{Utilities}
