% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis-functions.R
\name{cumulative_count_union}
\alias{cumulative_count_union}
\title{Integrations cumulative count in time by sample}
\usage{
cumulative_count_union(
  x,
  association_file = NULL,
  timepoint_column = "TimePoint",
  key = c("SubjectID", "CellMarker", "Tissue", "TimePoint"),
  include_tp_zero = FALSE,
  zero = "0000",
  aggregate = FALSE,
  ...
)
}
\arguments{
\item{x}{A simple integration matrix or an aggregated matrix (see details)}

\item{association_file}{NULL or the association file for x if \code{aggregate}
is set to TRUE}

\item{timepoint_column}{What is the name of the time point column?}

\item{key}{The aggregation key - must always contain the \code{timepoint_column}}

\item{include_tp_zero}{Include timepoint 0?}

\item{zero}{How is 0 coded in the data frame?}

\item{aggregate}{Should x be aggregated?}

\item{...}{Additional parameters to pass to \code{aggregate_values_by_key}}
}
\value{
A data frame
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#defunct}{\figure{lifecycle-defunct.svg}{options: alt='[Defunct]'}}}{\strong{[Defunct]}}
This function was deprecated in favour of a single function,
please use \code{cumulative_is} instead.
}
\examples{
\dontrun{
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
aggreg <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    value_cols = c("seqCount", "fragmentEstimate")
)
cumulative_count <- cumulative_count_union(aggreg)
cumulative_count
}
}
\keyword{internal}
