% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrid_prior.R
\name{hybrid}
\alias{hybrid}
\title{Transform a gene colocalization probability (GLCP) to a prior to be used in
the
evidence integration procedure. There are four prior function options,
including expit,
linear, step, and expit-linear hybrid.}
\usage{
hybrid(GLCP, t = 0.05, D = 0.1, u = 1, thresholding = "hard")
}
\arguments{
\item{GLCP}{A gene colocalization probability}

\item{t}{A hard threshold for the GLCP. Values below this number will be
shrunk to zero.
Default is 0.05.}

\item{D}{A curvature shrinkage parameter. Lower values of D will result in a
steeper curve.
Default is 0.1}

\item{u}{A factor between 0 and 1 by which the prior function is scaled.}

\item{thresholding}{An option to use hard thresholding or soft thresholding
for the prior function. Default is "hard". For soft thresholding, set to
"soft".}
}
\value{
The value of the prior.
}
\description{
Transform a gene colocalization probability (GLCP) to a prior to be used in
the
evidence integration procedure. There are four prior function options,
including expit,
linear, step, and expit-linear hybrid.
}
\examples{
hybrid(0.2, 0.05, 1)
}
