% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantifyExpressionsFromBWs.R
\name{quantifyExpressionsFromBWs}
\alias{quantifyExpressionsFromBWs}
\title{Evaluate introns and exons expressions from BAM or SAM files}
\usage{
quantifyExpressionsFromBWs(
  txdb,
  BWfiles,
  experimentalDesign,
  readLength = 50,
  by = c("gene", "tx"),
  libsize = c("assigned", "all"),
  DESeq2 = TRUE,
  varSamplingCondition = NULL,
  BPPARAM = SerialParam()
)
}
\arguments{
\item{txdb}{A TranscriptDB object}

\item{BWfiles}{A vector of paths}

\item{experimentalDesign}{A numerical which reports the desing of the experiment in terms of time points and replicates.
Time points must be ordered according to the sequence of files submitted for the analysis, these labels characterize
different files as replicates of a given condition.}

\item{readLength}{A numerical that indicates the read length of the RNA-seq experiment. Used to normalize the coverage. By default, 50.}

\item{by}{A character, either "gene" or "tx", indicating if expressions and counts should be summarized at the levels of 
genes or transcripts. "gene" by default.
In case "tx" is selected, we suggest to set argument "allowMultiOverlap" to TRUE, otherwise the reads mapping to overlapping
transcripts of the same gene will remain unassigned.}

\item{libsize}{A character, either "assigned" or "all", indicating whether the libsize for expression normalization should include all 
mapped reads or only the reads assigned to any of the features. By default, "assigned" is selected.}

\item{DESeq2}{A logical, if TRUE exons and introns variances are evaluated through the package DESeq2, if FALSE through plgem}

\item{varSamplingCondition}{A character reporting which experimental condition should be used to sample the variance if DESeq2 = FALSE.}

\item{BPPARAM}{Parallelization parameters for bplapply. By default SerialParam()
By default, the first element of "experimentalDesign" with replicates.}
}
\value{
A list containing expressions and associated variances for exons and introns.
}
\description{
Given a TranscriptDb object and a list of bigWig (BW) files 
"quantifyExpressionsFormBWs" evaluates exons and introns expressions
and the associated variances per each gene.
}
