% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/steadyNoNascent-methods.R
\docType{class}
\name{INSPEcT_steadyNoNascent-class}
\alias{INSPEcT_steadyNoNascent-class}
\alias{[,INSPEcT_steadyNoNascent,ANY,ANY,ANY-method}
\alias{show,INSPEcT_steadyNoNascent-method}
\title{An S4 class to represent steady-state analysis without nascent RNA}
\usage{
\S4method{[}{INSPEcT_steadyNoNascent,ANY,ANY,ANY}(x, i, j)

\S4method{show}{INSPEcT_steadyNoNascent}(object)
}
\arguments{
\item{x}{An object of class INSPEcT_steadyNoNascent}

\item{i}{A numeric, a vector of logicals indicating the rows to be extracted}

\item{j}{A numeric, a vector of logicals indicating the columns to be extracted}

\item{object}{An object of class INSPEcT_steadyNoNascent}
}
\value{
Method show for objects of class INSPEcT_steadyNoNascent
}
\description{
INSPEcT_steadyNoNascent is a class able to store data and arguments that are necessary to 
make the analysis concerning premature and mature expressions in different samples. In 
particular, the ratio between mature and premature can be calculated, which reflects
the ratio between the rates of processing and degradation in individaul genes 
(see \code{\link{PTratio}}), and the analysis of post-transcriptionally regualted genes
can be run to identify genes that in specfic samples show a trand which cannot be attributed
to transcriptional regulation alone (see \code{\link{PTreg}}).
}
\section{Slots}{

\describe{
\item{\code{sampleNames}}{Vector with the names of the samples (columns of the dataset)}

\item{\code{geneNames}}{Vector with the names of the genes (rows of the dataset)}

\item{\code{premature}}{Matrix containing the expressions of the premature RNAs (row=genes, columns=samples)}

\item{\code{mature}}{Matrix containing the expressions of the emature RNAs (row=genes, columns=samples)}

\item{\code{prematureVar}}{Matrix containing the expressions variances of the premature RNAs (row=genes, columns=samples)}

\item{\code{matureVar}}{Matrix containing the expressions variances of the emature RNAs (row=genes, columns=samples)}

\item{\code{trivialAngle}}{Numeric that indicates the angle (slope) of the linear model between mature and premature expressions}

\item{\code{log2FCThreshold}}{Numeric that describes the threshold of the variation to be considered significant}

\item{\code{expressionThreshold}}{Numeric that describes the threshold of the expression to consider the gene expressed}

\item{\code{referenceCondition}}{A sample identifier that set the reference for the post-transcriptional regulation analysis, 
if NULL the median of all samples is used}

\item{\code{ptreg}}{Matrix containing the post-transcriptioanl regulation state of each gene in the different samples (row=genes, columns=samples)}
}}

