% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/show-methods.R
\docType{class}
\name{INSPEcT-class}
\alias{INSPEcT-class}
\alias{show,INSPEcT-method}
\title{An S4 class to contain all rates and models generated by INSPEcT}
\usage{
\S4method{show}{INSPEcT}(object)
}
\arguments{
\item{object}{An object of class INSPEcT}
}
\value{
Method show for objects of class INSPEcT displays the main features
of the slots ratesFirstGuess, model and modelRates
}
\description{
INSPEcT is a class able to store all the estimated rates and concentrations (slot ratesFirstGuess), 
the modeled rates and concentrations (slot modelRates) and the model themselves (slot model).
Within the class INSPEcT other information regarding the experimental design are stored, such as the time
points where experiments were performed (slot tpts) and, if provided, the nascent RNA collecting time (slot tL)
and the normalization scale fators used for nascent (labeledSF) RNA-seq libraries.
A list of parameters that will be used during the 
modeling process is stored within the slot params and can be accessed by \code{\link{modelingParams}}.
A new instance of the class INSPEcT can be generated by the constructor function \code{\link{newINSPEcT}}.
}
\details{
Methods that apply to INSPEcT class are
\code{\link{AIC}} \cr
\code{\link[=Extract]{[}} \cr
\code{\link{calculateDelta}} \cr
\code{\link{calculateRatePvals}} \cr
\code{\link{calculateTau}} \cr
\code{\link{chisqmodel}} \cr
\code{\link{chisqtest}} \cr
\code{\link{combine}} \cr
\code{\link{compareSteady}} \cr
\code{\link{compareSteadyNoNascent}} \cr
\code{\link{computeConfidenceIntervals}} \cr
\code{\link{correlationPlot}} \cr
\code{\link{dim}} \cr
\code{\link{featureNames}} \cr
\code{\link{geneClass}} \cr
\code{\link{inHeatmap}} \cr
\code{\link{labeledSF}} \cr
\code{\link{logLik}} \cr
\code{\link{makeModelRates}} \cr
\code{\link{makeOscillatorySimModel}} \cr
\code{\link{makeSimModel}} \cr
\code{\link{modelRates}} \cr
\code{\link{modelRatesNF}} \cr
\code{\link{modelSelection}} \cr
\code{\link{modelingParams}} \cr
\code{\link{nGenes}} \cr
\code{\link{nTpts}} \cr
\code{\link{plotGene}} \cr
\code{\link{processingDelay}} \cr
\code{\link{ratePvals}} \cr
\code{\link{ratesFirstGuess}} \cr
\code{\link{ratesFirstGuessVar}} \cr
\code{\link{removeModel}} \cr
\code{\link{rocCurve}} \cr
\code{\link{rocThresholds}} \cr
\code{\link{setConfidenceIntervals}} \cr
\code{\link{show}} \cr
\code{\link{split}} \cr
\code{\link{tpts}} \cr
\code{\link{viewConfidenceIntervals}} \cr
\code{\link{viewModelRates}} \cr
}
\section{Slots}{

\describe{
\item{\code{params}}{A list of parameters of the modeling part}

\item{\code{ratesFirstGuess}}{An object of class ExpressionSet that contains all the rates and concentrations guessed from the first part of INSPEcT analysis (before modeling)}

\item{\code{ratesFirstGuessVar}}{An object of class ExpressionSet that contains the variances related to rates and concentrations guessed from the first part of INSPEcT analysis (before modeling)}

\item{\code{confidenceIntervals}}{An object of class ExpressionSet that contains the confidence intervals.}

\item{\code{model}}{An object of class INSPEcT_model that contains the output of the mdoeling.}

\item{\code{modelRates}}{An object of class ExpressionSet that contains all modeled the rates and concentrations.}

\item{\code{ratePvals}}{A matrix containing the p-value relative to the variability of synthesis, processing and degradation for each gene.}

\item{\code{tpts}}{A numeric vector of the time-points.}

\item{\code{labeledSF}}{A numeric vector of the scaling factor used for inter time-point normalization of Nascent-seq libraries.}

\item{\code{tL}}{A numeric containing the length of the Nascent pulse.}

\item{\code{NoNascent}}{A logical indicating if the nascent RNA was included into the analysis.}

\item{\code{NF}}{A logical indicating if the modeling approach is Non-Functional}

\item{\code{degDuringPulse}}{A logical indicating if degradation of RNA during the 4sU pulse was considered.}

\item{\code{version}}{A character indicating the version of INSPEcT that created the object}
}}

