% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{RunParallelICP}
\alias{RunParallelICP}
\alias{RunParallelICP.SingleCellExperiment}
\alias{RunParallelICP,SingleCellExperiment-method}
\title{Run ICP runs parallerly}
\usage{
RunParallelICP.SingleCellExperiment(
  object,
  k,
  d,
  L,
  r,
  C,
  reg.type,
  max.iter,
  threads
)

\S4method{RunParallelICP}{SingleCellExperiment}(
  object,
  k = 15,
  d = 0.3,
  L = 200,
  r = 5,
  C = 0.3,
  reg.type = "L1",
  max.iter = 200,
  threads = 0
)
}
\arguments{
\item{object}{An object of \code{SingleCellExperiment} class.}

\item{k}{A positive integer greater or equal to \code{2}, denoting
the number of clusters in Iterative Clustering Projection (ICP).
Decreasing \code{k} leads to smaller cell populations diversity
and vice versa. Default is \code{15}.}

\item{d}{A numeric greater than \code{0} and smaller than \code{1} that
determines how many cells \code{n} are down- or oversampled from each cluster
into the training data (\code{n=N/k*d}), where \code{N} is the total number
of cells, \code{k} is the number of clusters in ICP. Increasing above 0.3
leads greadually to smaller cell populations diversity.
Default is \code{0.3}.}

\item{L}{A positive integer greater than \code{1} denoting the number of
the ICP runs to run. Default is \code{200}. Increasing recommended with
a significantly larger sample size (tens of thousands of cells).
Default is \code{200}.}

\item{r}{A positive integer that denotes the number of reiterations
performed until the ICP algorithm stops.
Increasing recommended with a significantly larger sample size
(tens of thousands of cells). Default is \code{5}.}

\item{C}{A positive real number denoting the cost of constraints violation in
the L1-regularized logistic regression model from the LIBLINEAR library.
Decreasing leads to more stringent feature selection, i.e. less genes are
selected that are used to build the projection classifier. Decreasing to a
very low value (~ \code{0.01}) can lead to failure to identify central cell
populations. Default \code{0.3}.}

\item{reg.type}{"L1" or "L2". L2-regularization was not
investigated in the manuscript, but it leads to a more conventional
outcome (less subpopulations). Default is "L1".}

\item{max.iter}{A positive integer that denotes
the maximum number of iterations performed until ICP stops. This parameter
is only useful in situations where ICP converges extremely slowly, preventing
the algorithm to run too long. In most cases, reaching
the number of reiterations (\code{r=5}) terminates the algorithm.
Default is \code{200}.}

\item{threads}{A positive integer that specifies how many logical processors
(threads) to use in parallel computation.
Set \code{1} to disable parallelism altogether or \code{0} to use all
available threas except one. Default is \code{0}.}
}
\value{
an object of \code{SingleCellExperiment} class
}
\description{
This functions runs in parallel \code{L} ICP runs, which is the computational
bottleneck of ILoReg. With ~ 3,000 cells this step should be completed
in ~ 2 h and ~ 1 h with 3 and 12 logical processors (threads), respectively.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,r=1,k=5)

}
\keyword{ICP}
\keyword{LIBLINEAR}
\keyword{clustering}
\keyword{iterative}
\keyword{logistic}
\keyword{projection}
\keyword{regression}
