% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils.R
\name{RunICP}
\alias{RunICP}
\title{Iterative Clustering Projection (ICP) clustering}
\usage{
RunICP(
  normalized.data = NULL,
  k = 15,
  d = 0.3,
  r = 5,
  C = 5,
  reg.type = "L1",
  max.iter = 200
)
}
\arguments{
\item{normalized.data}{A sparse matrix (dgCMatrix) containing
normalized gene expression data with genes in rows and cells in columns.
Default is \code{NULL}.}

\item{k}{A positive integer greater or equal to 2, denoting the number of
clusters in ICP. Default is \code{15}.}

\item{d}{A numeric that defines how many cells per cluster should be
down- and oversampled (d in ceiling(N/k*d)), when stratified.downsampling=FALSE,
or what fraction should be downsampled in the stratified approach
,stratified.downsampling=TRUE. Default is \code{0.3}.}

\item{r}{A positive integer that denotes the number of reiterations
performed until the algorithm stops. Default is \code{5}.}

\item{C}{Cost of constraints violation (\code{C}) for L1-regulatization.
Default is \code{0.3}.}

\item{reg.type}{"L1" for LASSO and "L2" for Ridge. Default is "L1".}

\item{max.iter}{A positive integer that denotes the maximum number of
iterations performed until the algorithm ends. Default is \code{200}.}
}
\value{
A list that includes the probability matrix and the clustering
similarity measures: ARI, NMI, etc.
}
\description{
The function implements Iterative Clustering Projection (ICP): a
supervised learning -based clustering, which maximizes clustering similarity
between the clustering and its projection by logistic regression.
}
\keyword{ICP}
\keyword{clustering}
\keyword{iterative}
\keyword{projection}
