% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{RenameCluster}
\alias{RenameCluster}
\alias{RenameCluster.SingleCellExperiment}
\alias{RenameCluster,SingleCellExperiment-method}
\title{Renaming one cluster}
\usage{
RenameCluster.SingleCellExperiment(object, old.cluster.name, new.cluster.name)

\S4method{RenameCluster}{SingleCellExperiment}(object, old.cluster.name = "", new.cluster.name = "")
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}

\item{old.cluster.name}{a character variable denoting  the
old name of the cluster}

\item{new.cluster.name}{a character variable the
new name of the cluster}
}
\value{
object of \code{SingleCellExperiment} class
}
\description{
RenameCluster function enables renaming
a cluster in `clustering.manual` slot.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,k=5,r=1)
sce <- RunPCA(sce,p=5)
sce <- HierarchicalClustering(sce)
sce <- SelectKClusters(sce,K=5)
sce <- RenameCluster(sce,1,"cluster1")

}
\keyword{cluster}
\keyword{one}
\keyword{rename}
