% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{CalcSilhInfo}
\alias{CalcSilhInfo}
\alias{CalcSilhInfo.SingleCellExperiment}
\alias{CalcSilhInfo,SingleCellExperiment-method}
\title{Estimating optimal K using silhouette}
\usage{
CalcSilhInfo.SingleCellExperiment(object, K.start, K.end)

\S4method{CalcSilhInfo}{SingleCellExperiment}(object, K.start = 2, K.end = 50)
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}

\item{K.start}{a numeric for the smallest
K value to be tested. Default is \code{2}.}

\item{K.end}{a numeric for the largest
K value to be tested. Default is \code{50}.}
}
\value{
object of \code{SingleCellExperiment} class
}
\description{
The function estimates the optimal number of clusters K from the dendrogram
of the hierarhical clustering using the silhouette method.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,k=5,r=1)
sce <- RunPCA(sce,p=5)
sce <- HierarchicalClustering(sce)
sce <- CalcSilhInfo(sce)

}
\keyword{clustering}
\keyword{hierarchical}
\keyword{ward}
