% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_samplecor}
\alias{plot_samplecor}
\title{Plot a heatmap of pairwise sample correlations with hierarchical clustering}
\usage{
plot_samplecor(
  se,
  coldata_cols = NULL,
  rowdata_cols = NULL,
  ntop = 500,
  cor_method = "pearson",
  palette = "Blues",
  ...
)
}
\arguments{
\item{se}{A \code{SummarizedExperiment} object with a count matrix and sample
metadata in the \strong{colData} slot. If a \strong{rowData} slot is
available, it can also be used for clustering rows.}

\item{coldata_cols}{A vector (either numeric or character) indicating
which columns should be extracted from \strong{colData(se)}.}

\item{rowdata_cols}{A vector (either numeric or character) indicating
which columns should be extracted from \strong{rowData(se)}.}

\item{ntop}{Numeric indicating the number of top genes with the
highest variances to use for the PCA. Default: 500.}

\item{cor_method}{Character indicating the correlation method to use.
One of "pearson" or "spearman". Default: "pearson".}

\item{palette}{Character indicating the name of the color palette from
the RColorBrewer package to use. Default: "Blues".}

\item{...}{Additional arguments to be passed
to \code{ComplexHeatmap::pheatmap()}. These arguments can be used to control
heatmap aesthetics, such as show/hide row and column names,
change font size, activate/deactivate hierarchical clustering, etc. For a
complete list of the options, see \code{?ComplexHeatmap::pheatmap()}.}
}
\value{
A heatmap of hierarchically clustered pairwise sample correlations.
}
\description{
Plot a heatmap of pairwise sample correlations with hierarchical clustering
}
\examples{
data(se_chlamy)
se <- add_midparent_expression(se_chlamy)
se$Ploidy[is.na(se$Ploidy)] <- "midparent"
se$Generation[is.na(se$Generation)] <- "midparent"
plot_samplecor(se, ntop = 500)
}
