% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_expression_partitions}
\alias{plot_expression_partitions}
\title{Plot expression partitions}
\usage{
plot_expression_partitions(
  partition_table,
  group_by = "Category",
  palette = NULL,
  labels = c("P1", "F1", "P2")
)
}
\arguments{
\item{partition_table}{A data frame with genes per expression partition
as returned by \code{expression_partitioning()}.}

\item{group_by}{Character indicating the name of the variable
in \strong{partition_table} to use to group genes. One of "Category" or
"Class". Default: "Category".}

\item{palette}{Character vector with color names to be used for each level
of the variable specified in \strong{group_by}.
If \strong{group_by = "Category"}, this must be a vector of length 12.
If \strong{group_by = "Class"}, this must be a vector of length 5.
If NULL, a default color palette will be used.}

\item{labels}{A character vector of length 3 indicating the labels to be
given for parent 1, offspring, and parent 2.
Default: \code{c("P1", "F1", "P2")}.}
}
\value{
A ggplot object with a plot showing genes in each expression
partition.
}
\description{
Plot expression partitions
}
\examples{
data(deg_list)
partition_table <- expression_partitioning(deg_list)
plot_expression_partitions(partition_table)
}
