% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addMGnify.R
\name{addMGnify}
\alias{addMGnify}
\alias{addMGnify,SummarizedExperiment,MultiAssayExperiment-method}
\alias{addMGnify,SummarizedExperiment,SummarizedExperiment-method}
\alias{addMGnify,SummarizedExperiment,ANY-method}
\title{Add results from MGnifyR to HoloFoodR results}
\usage{
addMGnify(x, y, ...)

\S4method{addMGnify}{SummarizedExperiment,MultiAssayExperiment}(
  x,
  y,
  exp.name1 = "metagenomic",
  exp.name2 = "metagenomic_amplicon",
  replace = TRUE,
  ...
)

\S4method{addMGnify}{SummarizedExperiment,SummarizedExperiment}(x, y, ...)

\S4method{addMGnify}{SummarizedExperiment,ANY}(x, y, id.col1 = "sample_biosample", id.col2 = "accession", ...)
}
\arguments{
\item{x}{\code{SummarizedExperiment}. Results from
\code{MGnifyR::getResult()}.}

\item{y}{\code{MultiAssayExperiment} or \code{SummarizedExperiment} or
\code{data.frame}-like table. Results from \code{HoloFoodR::getResult()} or
sample metadata from it.}

\item{...}{optional arguments not used currently.}

\item{exp.name1}{\code{Character scalar}. Specifies the name of experiment
that will be added to \code{y}. (Default: \code{"metagenomic"})}

\item{exp.name2}{\code{Character scalar}. Specifies the name of experiment
from HoloFoodR results. This experiment is used to match IDs with MGnify
data. (Default: \code{"metagenomic_amplicon"})}

\item{replace}{\code{Logical scalar}. Whether to replace the template
experiment. (Default: \code{TRUE})}

\item{id.col1}{\code{Character scalar}. Specifies the name of column from
\code{colData(x)} that includes HoloFood identifiers.
(Default: \code{"sample_biosample"})}

\item{id.col2}{\code{Character scalar}. Specifies the name of column
from \code{colData(y[[exp.name2]])} that includes HoloFood identifiers.
(Default: \code{"accession"})}
}
\value{
\code{MultiAssayExperiment}
}
\description{
Add results from MGnifyR to HoloFoodR results
}
\details{
Metagenomic data is found in MGnify rather than HoloFoodR, and the two
databases use different sample identifiers. However, MGnify's sample
metadata includes references to the identifiers used in the HoloFood
database, making it straightforward to convert sample IDs for alignment
with HoloFood data. Despite this, HoloFood contains additional metadata
not available in MGnify. Moreover, integrating data into a
\code{MultiAssayExperiment} while maintaining accurate sample and system
matches can be challenging.

This function is designed to simplify these
tasks, enabling seamless integration of MGnify data with HoloFood data after
retrieval from the database. You need only to input the returned data from
\code{MGnifyR::getResult()} and \code{HoloFoodR::getResult()} functions.
}
\examples{

\dontrun{
# Get data from HoloFood database
mae <- HoloFoodR::getResult(
    salmon_sample_ids,
    use.cache = TRUE
)

# Get data from MGnify database
mg <- MgnifyClient(
    useCache = TRUE,
    cacheDir = ".MGnifyR_cache"
)
tse <- MGnifyR::getResult(
    mg,
    accession = mgnify_analyses_ids,
    get.func = FALSE
)

# Add MGnify data to HoloFood data
mae <- addMGnify(tse, mae)
}

}
